package org.msh.tb.entities;

import org.hibernate.validator.NotNull;
import org.msh.etbm.commons.transactionlog.Operation;
import org.msh.etbm.commons.transactionlog.mapping.PropertyLog;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Mauricio on 21/07/2017.
 * Entity that stores the notices sent from administrators to workspace users
 */
@Entity
@Table(name="usermessage")
public class UserMessage extends WSObject {

    @Id
    @GeneratedValue(strategy= GenerationType.AUTO)
    private Integer id;

    @ManyToOne(fetch= FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    @NotNull
    private User user;

    @NotNull
    @Temporal(TemporalType.DATE)
    private Date creationDate;

    @Column(length=300)
    @NotNull
    @PropertyLog(operations={Operation.NEW, Operation.DELETE})
    private String title;

    @NotNull
    private String message;

    /**
     * Users that have already read this message
     */
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="userreadmessage",
            joinColumns={@JoinColumn(name="MESSAGE_ID")},
            inverseJoinColumns={@JoinColumn(name="USERWORKSPACE_ID")})
    private List<UserWorkspace> users = new ArrayList<UserWorkspace>();

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<UserWorkspace> getUsers() {
        return users;
    }

    public void setUsers(List<UserWorkspace> users) {
        this.users = users;
    }
}
